package cn.com.duiba.kjy.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/8/16 4:27 PM
 */
public enum LotteryOrderStateEnum {

    NON_LOTTERY(0, "未出奖"),
    LOTTERY(1, "出奖中"),
    LOTTERY_SUCCESS(2, "出奖成功"),
    LOTTERY_FAIL(3, "出奖异常"),
    ;

    private Integer type;

    private String desc;

    LotteryOrderStateEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, LotteryOrderStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(LotteryOrderStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getType(), stateEnum);
        }
    }

    public static LotteryOrderStateEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

}
