package cn.com.duiba.kjy.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author lizhi
 * @date 2019/8/1 8:12 PM
 */
public enum PrizeTypeEnum {

    AGAIN(1, "再来一次"),
    THANKS(2, "谢谢参与"),
    SELLER_CUSTOM(3, "销售员定制"),
    OBJECT(4, "实物"),
    COUPON_LINK(5, "链接优惠券"),
    ;

    private Integer type;

    private String desc;

    PrizeTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, PrizeTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PrizeTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static PrizeTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 是否有中奖限制
     * @param type 奖品类型
     * @return true-有，false-没有
     */
    public static boolean isWinningLimit(Integer type) {
        PrizeTypeEnum typeEnum = getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum != AGAIN && typeEnum != THANKS;
    }

    public static boolean isWinning(Integer type) {
        if (Objects.isNull(type)) {
            return false;
        }
        return !Objects.equals(type, AGAIN.getType()) && !Objects.equals(type, THANKS.getType());
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
