package cn.com.duiba.kjy.api.util;


/**
 * Created by dugq on 2019-02-21.
 */
public enum ErrorCode implements ErrorCodeInterface {
    //通用
    DATE_ERROR("990001","数据错误"),
    SYSTEM("999999","系统错误"),

    //00 : 内容
    N000000("000000","内容模块"),
    INSERT_ERROR("000001","内容主表插入失败"),
    CONTENT_EXT_ERROR("000002","内容扩展表插入失败"),
    TARGET_SORT_ERROR("000003","目标位置不存在，目标位置超过了总数"),
    N000004("000004", "内容互动问题数据创建失败"),
    N000005("000005", "内容互动选项创建失败"),
    N000006("000006", "用户互动投票记录创建失败"),
    N000007("000007", "内容互动问题数据修改失败"),
    N000008("000008", "内容互动选项修改失败"),
    N000009("000009", "用户互动投票记录修改失败"),
    N000010("000010", "用户多选项投票记录失败"),
    N000011("000011", "该内容已存在互动"),


    //01 销售模块
    N010001("010001","更新用户信息错误"),
    N010002("010002","支付记录状态错误"),

    //02 用户模块
    N020001("020001","保存用户信息错误"),
    N020002("020002","保存用户扩展信息错误"),
    N020003("020003","更新用户信息错误"),
    N020004("020004","保存用户扩展信息错误"),
    N020005("020005","更新用户扩展信息错误"),

    //03激活码
    ALREADY_USED("030001","激活码已经使用"),
    NOT_SELLER("030002","非销售不能激活"),
    UN_USEFUL("030003","无用的或者非法的激活码"),
    ADD_VIP_TIME("030004","添加vip时间错误"),
    ALREADY_ACTIVATED("030005","该用户已经使用过一次了"),

    //04首页分类
    BUSY_MOVING("040001","移动过去频繁"),

    // 05 资料库管理
    N050001("050001", "文章不存在"),
    N050002("050002", "公司不存在"),
    ;

    private String shortCode;
    private String desc;

    ErrorCode(String shortCode, String desc) {
        this.shortCode = shortCode;
        this.desc = desc;
    }

    @Override
    public String getHost() {
        return "01";
    }

    @Override
    public String getShortCode() {
        return shortCode;
    }

    public String getDesc() {
        return desc;
    }
}
