package cn.com.duiba.kjy.api.enums.push;

import java.util.Objects;

/**
 * 推送标签
 * @author lizhi
 * @date 2019/6/24 1:51 PM
 */
public enum PushLabelEnum {
    //推送类型标签
    MATERIAL(1, "素材更新"),
    VISIT_ME(2, "谁看过我"),
    VIP_EXCLUSIVE(3, "会员专属"),
    ;

    private Integer label;
    private String labelName;

    PushLabelEnum(Integer label, String labelName) {
        this.label = label;
        this.labelName = labelName;
    }

    public boolean needVip() {
        return Objects.equals(this, VIP_EXCLUSIVE);
    }

    public Integer getLabel() {
        return label;
    }

    public String getLabelName() {
        return labelName;
    }
}
