package cn.com.duiba.kjy.api.params.whosawme;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * tb_seller_content 获客效果分析检索参数
 * @author 吴文哲
 * @date 2019-08-30 16:39
 **/
@Data
@Slf4j
public class SellerContentJobParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -5893560208278657259L;

    /**
     * 创建时间 距离现在24小时前
     */
    private Date gmtCreate;

    /**
     * 获客指数星级
     */
    private Integer star;

    /**
     * 获客得分
     */
    private Integer score;

    /**
     * 代理人Id
     */
    private Long sellerId;

    /**
     * 不包含的内容类型
     */
    private List<String> excludeContentTypes;



}
