package cn.com.duiba.kjy.api.constant;

/**
 * Created by zhangshun on 2019/2/13.
 */
public enum UserExtTypeEnum {

    OA("oa", "客集集公众号"),
    MP("mp", "小程序"),
    VIP("vip","客集集VIP公众号"),


    //-----------------------------------------------
    /**
     * !!!important 这不是数据库类型哦！！！仅在查询时使用。
     *  场景： 在某些情况下，需求要求： 消息优先发送客集集VIP公众号，再发客集集公众号。在查询时使用此对象
     * 必须经过userExtService处理
     */
    VIP_OA("vipOa","优先客集集VIP公众号，其次客集集公众号"),
    CLIENT_MP("client_mp","客户小程序")

    ;

    private String code;
    private String desc;

    UserExtTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static UserExtTypeEnum of(String code) {
        if (code == null) {
            return null;
        }
        for (UserExtTypeEnum typeEnum : UserExtTypeEnum.values()) {
            if (typeEnum.getCode().equals(code)) {
                return typeEnum;
            }
        }
        throw new UnsupportedOperationException("不支持的ext类型");
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
