package cn.com.duiba.kjy.api.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zhangshun on 2019/2/13.
 */
@Data
@ToString
public class SellerCustomerDto implements Serializable {
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     *
     *最后访问时间
     */
    private Date lastVisitTime;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 备注名称
     */
    private String remarkName;

    /**
     * 备注名称拼音
     */
    private String remarkNamePinyin;

    /**
     * 备注名称拼音,首字母
     */
    private String remarkNamePinyinFast;

    /**
     * 顾客意向，企业产品ID，多个英文逗号隔开
     */
    private String custTag;

    /**
     * 顾客电话
     */
    private String custPhone;

    /**
     * 顾客：省
     */
    private String custProvince;

    /**
     * 顾客：市
     */
    private String custCity;

    /**
     * 顾客：区
     */
    private String custArea;

    /**
     * 顾客：备注
     */
    private String custRemark;

    /**
     * 顾客标志
     */
    private Integer custMark;

    /**
     * 是否与代理人有一级接触
     */
    private Integer isTouched;

    /**
     * 客户的生日信息
     */
    private String custBirth;

    /**
     * 客户意向度星级
     */
    private Integer star;

    /**
     * 客户意向度得分
     */
    private Integer score;

    /**
     * 客户来源 1:微信好友 2:二度人脉
     */
    private Integer custOrigin;




    @Data
    public static class CustBirth implements Serializable {
        private Integer isSolarBirthDay;
        private String custBirthDay;
    }
}
