package cn.com.duiba.kjy.api.params;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zhangshun on 2019/6/3.
 */
@Data
@ToString
public class SellerSearchParam extends PageQuery implements Serializable {

    private static final long serialVersionUID = -2983371748132642436L;

    private Long companyId;
    private Integer vip;
    private Integer deleted;
    //seller创建时间
    private Date gmtCreate;
    /**
     * 是否按照创建倒序，默认倒序
     */
    private boolean gmtCreateDesc = true;

    /**
     * 微信昵称
     */
    private String wxNickname;

    /**
     * 特权会员登录手机号
     */
    private String loginPhone;

    /**
     * 会员类型
     */
    private Integer vipType;

    /**
     * 升为特权会员的时间  开始时间
     */
    private Date upgradeStartDate;

    /**
     * 升为特权会员的时间  结束时间
     */
    private Date upgradeEndDate;

    /**
     * 代理人手机号
     */
    private String sellerPhone;

    /**
     * 时间次序
     */
    public String getGmtCreateOrder() {
        return gmtCreateDesc ? "desc" : "asc";
    }
}
