package cn.com.duiba.kjy.api.constant;

import cn.com.duiba.kjy.api.enums.OATypeEnum;

/**
 * 微信发送消息-事件类型
 * @Auther: Tt(yehuawei)
 * @Date: 2019/7/3 0003 16:17
 */
public enum WeChatSendEventEnum {
    /**
     * 客户进入聊天页事件
     */
    USER_IN_EVENT("USER_FIRST_IN_CHAT_PAGE",UserExtTypeEnum.VIP_OA,"客户首次进入本次会话聊天页"),
    /**
     * 客户留言事件
     */
    USER_SEND_EVENT("USER_SEND_MESSAGE",UserExtTypeEnum.VIP_OA,"客户在本次会话中发送消息"),
    /**
     * 代理人留言事件
     */
//    SELLER_SEND_EVENT("SELLER_SEND_EVENT",UserExtTypeEnum.MP,"代理人留言，客户在小程序上接收提醒"),
    ;

    /**
     * 事件
     */
    private String event;
    /**
     * 负责推送该事件消息的微信oa类型
     */
    private UserExtTypeEnum userExtTypeEnum;
    /**
     * 描述
     */
    private String desc;

    WeChatSendEventEnum(String event, UserExtTypeEnum userExtTypeEnum, String desc) {
        this.event = event;
        this.userExtTypeEnum = userExtTypeEnum;
        this.desc = desc;
    }

    public static WeChatSendEventEnum byEvent(String event){
        for (WeChatSendEventEnum weChatSendEventEnum:values()){
            if (event.equals(weChatSendEventEnum.getEvent())){
                return weChatSendEventEnum;
            }
        }
        return null;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public UserExtTypeEnum getUserExtTypeEnum() {
        return userExtTypeEnum;
    }

    public void setUserExtTypeEnum(UserExtTypeEnum userExtTypeEnum) {
        this.userExtTypeEnum = userExtTypeEnum;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
