package cn.com.duiba.kjy.api.enums.seller;

import java.util.Arrays;
import java.util.List;

/**
 * 销售员账户明细业务类型枚举
 * @author zhanghuifeng
 * date 2019-05-17-11:11
 */
public enum SellerAccountBizTypeEnum {
    //添加收益类型的枚举时，要更改getIncomeDetailTypes方法的返回值。
    WITHDRAW(1, "余额提现"),
    INVITE_AWARD(2, "邀请奖励"),
    SECOND_INVITE_AWARD(3, "二级奖励"),
    WITHDRAW_BACK(4, "余额提现失败退回"),
    FIRST_ORDER_INVITE_AWARD(5, "一级阶梯邀请单人奖励"),
    FIRST_ORDER_INVITE_EXTRA_AWARD(6, "一级阶梯邀请一次性奖励"),
    SP_INVITE_AWARD(7, "会销邀请返佣"),
    ENOUGH_COMMISSION_AWARD(8, "满额返佣奖励"),
    ;
    private Integer code;

    private String desc;

    SellerAccountBizTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static SellerAccountBizTypeEnum getByCode(Integer code) {
        for (SellerAccountBizTypeEnum enumVal : SellerAccountBizTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(Integer code) {
        for (SellerAccountBizTypeEnum enumVal : SellerAccountBizTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    /**
     * 获取所有收益类型
     */
    public static List<Integer> getIncomeDetailTypes() {
        return Arrays.asList(INVITE_AWARD.getCode(),
                SECOND_INVITE_AWARD.getCode(),
                FIRST_ORDER_INVITE_AWARD.getCode(),
                FIRST_ORDER_INVITE_EXTRA_AWARD.getCode(),
                SP_INVITE_AWARD.getCode(),
                ENOUGH_COMMISSION_AWARD.getCode());
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
