/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.mp;

import cn.com.duiba.kjy.api.constant.UserRoleEnum;
import cn.com.duiba.kjy.api.enums.OATypeEnum;
import org.apache.commons.lang.StringUtils;

public enum LoginSceneEnum {
    DEFAULT("Default", OATypeEnum.MP, UserRoleEnum.SELLER, "\u9ed8\u8ba4\u573a\u666f\uff0c\u517c\u5bb9\u539f\u6709\u4ee3\u7801\uff0c\u539f\u6709\u4ee3\u7801\u9ed8\u8ba4\u4e3aDEFAULT\u573a\u666f"),
    PRIVATE_CHAT_LOGIN("PrivateChat", OATypeEnum.MP, UserRoleEnum.USER, "\u901a\u8fc7\u79c1\u4fe1\u63a8\u9001\u7684\u4e8c\u7ef4\u7801\u8fdb\u5165\u5c0f\u7a0b\u5e8f\uff0c\u6388\u6743\u540e\u4e3a\u5ba2\u6237"),
    SHARE_MINIPROGRAM_CONTENT_CARD("ShareMiniprogram", OATypeEnum.MP, UserRoleEnum.USER, "\u901a\u8fc7\u5176\u4ed6\u4ee3\u7406\u4eba\u5206\u4eab\u7684\u5185\u5bb9\u5c0f\u7a0b\u5e8f\u5361\u7247\uff0c\u6388\u6743\u540e\u6210\u4e3a\u5ba2\u6237"),
    SEARCH_MINIPROGRAM("SearchMiniprogram", OATypeEnum.MP, UserRoleEnum.SELLER, "\u901a\u8fc7\u81ea\u7136\u641c\u7d22\u5c0f\u7a0b\u5e8f\uff0c\u6388\u6743\u540e\u6210\u4e3a\u9500\u552e\u8eab\u4efd"),
    SCAN_MINIPROGRAM_QRCODE("ScanMiniprogramQrcode", OATypeEnum.MP, UserRoleEnum.SELLER, "\u901a\u8fc7\u626b\u63cf\u5c0f\u7a0b\u5e8f\u7801\uff0c\u6388\u6743\u6210\u4e3a\u9500\u552e\u8eab\u4efd");

    private String scene;
    private String desc;
    private OATypeEnum oaType;
    private UserRoleEnum role;

    private LoginSceneEnum(String scene, OATypeEnum oaType, UserRoleEnum role, String desc) {
        this.scene = scene;
        this.desc = desc;
        this.oaType = oaType;
        this.role = role;
    }

    public static LoginSceneEnum Of(String scene) {
        if (StringUtils.isBlank((String)scene)) {
            return DEFAULT;
        }
        for (LoginSceneEnum loginSceneEnum : LoginSceneEnum.values()) {
            if (!scene.equals(loginSceneEnum.getScene())) continue;
            return loginSceneEnum;
        }
        return DEFAULT;
    }

    public String getScene() {
        return this.scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public OATypeEnum getOaType() {
        return this.oaType;
    }

    public void setOaType(OATypeEnum oaType) {
        this.oaType = oaType;
    }

    public UserRoleEnum getRole() {
        return this.role;
    }

    public void setRole(UserRoleEnum role) {
        this.role = role;
    }
}

