package cn.com.duiba.kjy.api.params.privatechat;

import lombok.Data;

import java.io.Serializable;

/**
 * @Auther: Tt(yehuawei)
 * @Date: 2019/6/28 0028 10:30
 */
@Data
public class ChatSendParam implements Serializable {
    private static final long serialVersionUID = -1140535032512107844L;
    /**
     * 当前用户的角色， 1=代理人 2=客户
     */
    private Integer role;

    /**
     * 发送人id 当发送人为客户时为user_id 代理人时为seller_id
     */
    private Long mineRoleId;
    /**
     * 会话另一方的id，当前角色为客户时另一方id为sellerId, 当前角色为代理人时为userId
     */
    private Long anotherId;
    /**
     * 聊天内容，如果聊天内容包含图片那么聊天内容像这样 <img src='图片地址'/>
     */
    private String content;
    /**
     * 会话id
     */
    private String sessionId;
}
