package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.weekly.SellerWeeklyPublicationDto;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019-08-15 11:29
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerWeeklyPublicationService {

    /**
     * 根据代理人id查询周报列表
     * @param sellerId
     * @return
     */
    List<SellerWeeklyPublicationDto> listWeeklyPublication(Long sellerId);


    /**
     * 根据代理人id和周数返回周报信息
     * @param sellerId
     * @param weekNum
     * @return
     */
    SellerWeeklyPublicationDto selectWeeklyPublicationInfo(Long sellerId, Integer weekNum);

    /**
     * 根据海报id查询
     * @param id
     * @return
     */
    SellerWeeklyPublicationDto listById(Long id);

    /**
     * 添加到周报已访问列表
     * @param sellerId
     */
    void add2AccessList(Long sellerId, Integer weekNum);

    /**
     * 代理人是否已访问周报
     * @param sellerId
     * @return
     */
    Boolean hasAccessed(Long sellerId, Integer weekNum);
}
