package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SellerActivityVisitDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SellerActivityVisitParam;

import java.util.List;
import java.util.Map;

/**
 * @auther: linjianhui
 * @date: 2019-03-16 11:40
 * @description: 用户活动参与表单记录相关服务
 */
@AdvancedFeignClient
public interface RemoteSellerActivityVisitService {

    /**
     * 更新保单已处理
     *
     * @param id
     * @return
     */
    Boolean updateAlreadyRead(Long id);

    Boolean updateSellerVisitBind(Long sellerId, Long visitId);

    /**
     * 插入参与表单
     *
     * @param sellerActivityVisitDto
     * @return
     */
    Long insertActivityVisit(SellerActivityVisitDto sellerActivityVisitDto);

    Boolean updateActivityVisit(SellerActivityVisitDto sellerActivityVisitDto);

    /**
     * 查询未处理条数
     *
     * @param param
     * @return
     */
    Map<String, Long> countUnReadMark(SellerActivityVisitParam param);

    /**
     * 通过id查询参与表单
     *
     * @param id
     * @return
     */
    SellerActivityVisitDto findById(Long id);

    /**
     * 查询是否有表单记录
     * @param activityId
     * @param sellerId
     * @param visitId
     * @return
     */
    SellerActivityVisitDto findByIdParams(Long activityId, Long sellerId, Long visitId);


    List<SellerActivityVisitDto> findBySellerId(Long sellerId);

    List<SellerActivityVisitDto> findBySellerActivity(Long sellerId, Long activityId);

    /**
     * 谁看过我 获取中奖总数
     * @param sellerId
     * @param userId
     * @param ActivityId
     * @return
     */
    Integer countPrizeUserNum(Long sellerId, Long userId, Long ActivityId);


    /**
     * 分页查询
     * @param param
     * @return
     */
    Page<SellerActivityVisitDto> getWinnerPage(SellerActivityVisitParam param);

    /**
     * 获取中奖userIds
     * @param sellerId
     * @param activityIds
     * @return contentId, List<> winnerUserIds
     */
    Map<Long, List<Long>> getPrizeUserMap(Long sellerId, List<Long> activityIds);

    /**
     * 根据访问记录 查询对应中奖信息
     * @param tbVisitIds
     * @return
     */
    List<SellerActivityVisitDto> getLotterysByTbVisitId(List<Long> tbVisitIds);


    /**
     * 根据条件查询中奖信息列表
     * @param param
     * @return
     */
    List<SellerActivityVisitDto> getLotteryByCondition(SellerActivityVisitParam param);

    /**
     * 总数
     * @param param
     * @return
     */
    Long countLotteryByCondition(SellerActivityVisitParam param);

    /**
     * 根据contentId 统计次数
     * @param contentIds
     * @return
     */
    Map<Long, Integer> countNumByScIds(List<Long> contentIds);

    /**
     * 批量更新已读
     * @param ids
     * @return
     */
    Integer updateAlreadyReadBatch(List<Long> ids);
}
