package cn.com.duiba.kjy.api.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * 用于排序的工具
 * @author 吴文哲
 * @date 2019-09-06 15:03
 **/
public class SortUtil {

    /**
     * 排序工具
     *
     * @param id2ScoreMap id:唯一键 score:得分
     *
     * @return  返回一个以id为主键 值为排名的Map  同分数的排名顺序相同
     */
    public static Map<Long, Integer> sortMap(Map<Long, Integer> id2ScoreMap) {
        //排序
        Map<Long, Integer> sortedMap = new LinkedHashMap<>();
        id2ScoreMap.entrySet().stream().sorted(Comparator.comparing(e -> -e.getValue())).forEach(e -> sortedMap.put(e.getKey(), e.getValue()));
        //算出排名 分数相同排名相同
        Map<Long, Integer> sameScoreSortMap = new LinkedHashMap<>();
        //分数对应排名  key: 分数 value 标记该分数是否出现过
        Map<Integer, Boolean> score2RankMap = new HashMap<>();
        //排名
        int rank = 0;
        for(Map.Entry<Long,Integer>  entry : sortedMap.entrySet()){
            //分数是否出现
            Boolean appear = score2RankMap.get(entry.getValue());
            if(appear == null){
                //没有出现过标记一下
                score2RankMap.put(entry.getValue(),true);
                rank++;
            }
            sameScoreSortMap.put(entry.getKey(),rank);
        }
        return sameScoreSortMap;
    }
}
