package cn.com.duiba.kjy.api.dto;

import cn.com.duiba.kjy.api.enums.seller.SellerShowQrCodeTypeEnum;
import cn.com.duiba.kjy.api.enums.seller.SellerSpSwitchEnum;
import cn.com.duiba.kjy.api.enums.seller.SellerVipTypeEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhangshun
 * @description 销售信息
 * @date 2019-02-13
 */
@Data
@ToString
public class SellerDto implements Serializable {

    private static final long serialVersionUID = 1474342377011340192L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 是否删除，1=已删除，0=未删除
     */
    private Integer deleted;

    /**
     * 用户ID，对应tb_users.id
     */
    private Long userId;

    /**
     * 销售员昵称
     */
    private String sellerName;

    /**
     * 销售员微信号
     */
    private String wechatNumber;

    /**
     * 销售员手机号
     */
    private String phoneNumber;

    /**
     * 销售员职位
     */
    private String jobPost;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 付款金额，单位：分
     */
    private Integer amount;

    /**
     * 是否通知
     */
    private Integer notification;

    /**
     * vip级别，0=不是、1=是
     */
    private Integer vip;

    /**
     * vip开始时间
     */
    private Date vipBeginTime;

    /**
     * vip结束时间
     */
    private Date vipEndTime;

    /**
     * 我的二维码
     */
    private String qrCode;

    /**
     * 我的二维码
     */
    private String wechatQrCode;

    /**
     * 扩展字段
     */
    private String ext;

    /**
     * 公司ID
     */
    private Long companyId;

    private SellerExtDto sellerExtDto;


    /**
     * 销售员特殊类型
     * @see SellerSpSwitchEnum
     */
    private Integer sellerSpType;

    /**
     * 会员类型
     * @see SellerVipTypeEnum
     */
    private Integer vipType;

    /**
     * 展示二维码类型
     * @see SellerShowQrCodeTypeEnum
     */
    private Integer showQrCodeType;

    /**
     * 是否付费 0-未付费 1-付费
     */
    private Integer isPaid;

    /**
     * 后台登录手机号
     */
    private String loginPhone;

    /**
     * 升级为特权会员的时间
     */
    private Date gmtPrivilege;

    /**
     * 销售自定头像
     */
    private String avatar;

    /**
     * 英文名
     */
    private String englishName;

    /**
     * 自我介绍
     */
    private String personalIntro;

}
