package cn.com.duiba.kjy.api.dto.interaction;

import cn.com.duiba.kjy.api.dto.contentinteractionoption.ContentInteractionOptionDto;
import cn.com.duiba.kjy.api.dto.contentinteractionvote.ContentInteractionVoteDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2019/8/31 10:03 AM
 */
@Data
public class ContentInteractionDto implements Serializable {

    private static final long serialVersionUID = 9050988944253212368L;

    /**
     *
     *主键
     */
    private Long id;

    /**
     * 内容id
     */
    private Long contentId;

    /**
     * 销售员转载ID
     */
    private Long scId;

    /**
     * 互动类型 0问答题单选 1问答题多选 2投票单选 3投票多选
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTypeEnum
     */
    private Integer interactionType;

    /**
     * 标题
     */
    private String title;

    /**
     * 答案说明
     */
    private String instructions;

    /**
     * 一级标题
     */
    private String oneTitle;

    /**
     * 选项（答题类型时有值）
     */
    private List<ContentInteractionOptionDto> options;

    /**
     * 投票项（投票类型时有值）
     */
    private List<ContentInteractionVoteDto> votes;

    /**
     * 表格字段（表格类型时有值）
     */
    private List<ContentInteractionTableFieldDto> tableFields;

}
