package cn.com.duiba.kjy.api.dto.interaction;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2019/9/9 3:20 PM
 */
@Data
public class InteractionMaterialContentDto implements Serializable {

    private static final long serialVersionUID = 749441664754596130L;

    /**
     * 互动ID
     */
    private Long interactionId;

    /**
     * 选项/投票项ID集合
     */
    private List<Long> options;

    /**
     * 表格字段值
     */
    private List<FieldValueDto> fieldValues;

    @Data
    public static class FieldValueDto implements Serializable {

        private static final long serialVersionUID = -5484897384950505652L;

        /**
         * 表格字段ID
         */
        private Long id;

        /**
         * 表格字段值
         */
        private String fieldValue;

        /**
         * 选项类型表格字段的选项ID集合
         */
        private List<Long> fieldOptions;
    }
}
