package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/9/5 12:20 PM
 */
public enum  InteractionOptionAnswerEnum {

    ANSWER(0, "是答案"),
    NON_ANSWER(1, "不是答案"),
    ;

    private Integer code;

    private String desc;

    InteractionOptionAnswerEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, InteractionOptionAnswerEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionOptionAnswerEnum answerEnum : values()){
            ENUM_MAP.put(answerEnum.getCode(), answerEnum);
        }
    }

    public static InteractionOptionAnswerEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
