package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/8/30 4:06 PM
 */
public enum InteractionTemplateSelectionTypeEnum {

    SINGLE(0, "单选"),
    MULTIPLE(1, "多选"),
    ;

    private Integer type;

    private String desc;

    InteractionTemplateSelectionTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, InteractionTemplateSelectionTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionTemplateSelectionTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static InteractionTemplateSelectionTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static InteractionTemplateSelectionTypeEnum getByInteractionTypeEnum(InteractionTypeEnum typeEnum) {
        if (typeEnum == null) {
            return null;
        }
        if (typeEnum.isMultiple()) {
            return MULTIPLE;
        }
        if (typeEnum.isSingle()) {
            return SINGLE;
        }
        return null;
    }
}
