package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/8/30 4:10 PM
 */
public enum InteractionTemplateStateEnum {

    NON_OPEN(0, "未启用"),
    OPEN(1, "启用"),
    ;

    private Integer code;

    private String desc;

    InteractionTemplateStateEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, InteractionTemplateStateEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionTemplateStateEnum stateEnum : values()){
            ENUM_MAP.put(stateEnum.getCode(), stateEnum);
        }
    }

    public static InteractionTemplateStateEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }
}
