package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/9/4 4:59 PM
 */
public enum InteractionTypeEnum {
    //0问答题单选 1问答题多选 2投票单选 3投票多选
    ANSWER_SINGLE(0, "问答题单选"),
    ANSWER_MULTIPLE(1, "问答题多选"),
    VOTE_SINGLE(2, "投票单选"),
    VOTE_MULTIPLE(3, "投票多选"),

    SELLER_ANSWER_SINGLE(4, "销售员配置答题单选"),
    SELLER_ANSWER_MULTIPLE(5, "销售员配置答题多选"),
    SELLER_VOTE_SINGLE(6, "销售员配置投票单选"),
    SELLER_VOTE_MULTIPLE(7, "销售员配置投票多选"),
    SELLER_TABLE(8, "销售员配置表格"),
    ;

    private Integer type;

    private String desc;

    InteractionTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public boolean isAnswer() {
        return this == ANSWER_SINGLE || this == ANSWER_MULTIPLE
                || this == SELLER_ANSWER_SINGLE || this == SELLER_ANSWER_MULTIPLE;
    }

    public boolean isVote() {
        return this == VOTE_SINGLE || this == VOTE_MULTIPLE
                || this == SELLER_VOTE_SINGLE || this == SELLER_VOTE_MULTIPLE;
    }

    public boolean isTable() {
        return this == SELLER_TABLE;
    }

    public boolean isSingle() {
        return this == ANSWER_SINGLE || this == VOTE_SINGLE
                || this == SELLER_ANSWER_SINGLE || this == SELLER_VOTE_SINGLE;
    }

    public boolean isMultiple() {
        return this == ANSWER_MULTIPLE || this == VOTE_MULTIPLE
                || this == SELLER_ANSWER_MULTIPLE || this == SELLER_VOTE_MULTIPLE;
    }

    private static final Map<Integer, InteractionTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static InteractionTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 根据模板类型和选项类型，获取互动类型
     * @param typeEnum 模板类型
     * @param selectionTypeEnum 选项类型
     * @return 互动类型
     */
    public static InteractionTypeEnum getByTemplateEnumAndSelectionTypeEnum(InteractionTemplateTypeEnum typeEnum,
                                                                            InteractionTemplateSelectionTypeEnum selectionTypeEnum) {
        if (typeEnum == null) {
            return null;
        }
        if (typeEnum == InteractionTemplateTypeEnum.TABLE) {
            return InteractionTypeEnum.SELLER_TABLE;
        }
        if (selectionTypeEnum == null) {
            return null;
        }
        if (typeEnum == InteractionTemplateTypeEnum.VOTE) {
            if (selectionTypeEnum == InteractionTemplateSelectionTypeEnum.SINGLE) {
                return InteractionTypeEnum.SELLER_VOTE_SINGLE;
            }
            if (selectionTypeEnum == InteractionTemplateSelectionTypeEnum.MULTIPLE) {
                return InteractionTypeEnum.SELLER_VOTE_MULTIPLE;
            }
            return null;
        }
        if (typeEnum == InteractionTemplateTypeEnum.ANSWER) {
            if (selectionTypeEnum == InteractionTemplateSelectionTypeEnum.SINGLE) {
                return InteractionTypeEnum.SELLER_ANSWER_SINGLE;
            }
            if (selectionTypeEnum == InteractionTemplateSelectionTypeEnum.MULTIPLE) {
                return InteractionTypeEnum.SELLER_ANSWER_MULTIPLE;
            }
            return null;
        }
        return null;
    }
}
