package cn.com.duiba.kjy.api.remoteservice.interaction;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.interaction.ContentInteractionDto;

/**
 * @author lizhi
 * @date 2019/9/7 4:13 PM
 */
@AdvancedFeignClient
public interface RemoteContentInteractionService {

    /**
     * 新增或更新
     * @param interactionDto 互动信息
     * @return 互动主键
     */
    Long saveOrUpdate(ContentInteractionDto interactionDto);

    /**
     * 根据销售员转载ID查询互动及互动详情（投票、答题、表格信息）
     * @param scId 销售员转载内容ID
     * @return 互动详情
     */
    ContentInteractionDto findDetailByScIdCache(Long scId);

}
