package cn.com.duiba.kjy.api.remoteservice.interaction;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.interaction.ContentInteractionTemplateDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.interaction.ContentInteractionTemplateSearchParams;

/**
 * @author lizhi
 * @date 2019/9/6 12:15 PM
 */
@AdvancedFeignClient
public interface RemoteContentInteractionTemplateService {

    /**
     * 新增或更新模板
     * @param templateDto 模板参数
     * @return 主键
     */
    Long saveOrUpdateTemplate(ContentInteractionTemplateDto templateDto);

    /**
     * 根据主键查询模板及模板详细信息
     * @param id 主键
     * @return 模板及模板详细信息
     */
    ContentInteractionTemplateDto findDetailById(Long id);

    /**
     * 根据主键查询模板
     * @param id 主键
     * @return 模板
     */
    ContentInteractionTemplateDto findById(Long id);

    /**
     * 分页查询
     * @param params 分页查询参数
     * @return 列表
     */
    Page<ContentInteractionTemplateDto> findPage(ContentInteractionTemplateSearchParams params);

    /**
     * 删除模板
     * @param id 主键
     * @return 执行结果
     */
    int deleted(Long id);

    /**
     * 更改模板状态
     * @param id 主键
     * @param state 状态
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateStateEnum
     * @return 执行结果
     */
    int updateState(Long id, Integer state);

    /**
     * 模板使用次数+1
     * @param id 主键
     * @return 执行结果
     */
    int increaseUseTimes(Long id);
}
