/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

import java.net.URLDecoder;
import java.util.Base64;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class IdMakerUtil {
    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static final String PREFIX = "Kjj";

    private IdMakerUtil() {
    }

    public static String encodingId(Long id) {
        if (Objects.isNull(id)) {
            return null;
        }
        id = id << 3 ^ 7L;
        String encode = ENCODER.encodeToString(Long.toString(id).getBytes());
        String encodeStr = PREFIX + encode.charAt(1) + encode;
        return Hex.encodeHexString((byte[])encodeStr.getBytes());
    }

    public static Long decodingId(String encode) {
        if (encode == null || "".equals(encode)) {
            return null;
        }
        try {
            if (!encode.startsWith(PREFIX)) {
                encode = new String(Hex.decodeHex((char[])encode.toCharArray()));
            }
            String substring = IdMakerUtil.decoder(encode).substring(4);
            String decode = new String(DECODER.decode(substring));
            return Long.valueOf(decode) >> 3;
        }
        catch (DecoderException e) {
            return null;
        }
    }

    private static String decoder(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception exception) {
            return url;
        }
    }
}

