package cn.com.duiba.kjy.api.dto.privatechat;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 聊天记录Dto
 * @Auther: Tt(yehuawei)
 * @Date: 2019/6/28 0028 15:03
 */
@Data
public class ChatContentDto implements Serializable {

    private static final long serialVersionUID = 772358762291259312L;
    /**
     * 主键id
     */
    private Long id;
    /**
     * 发送人id
     */
    private Long senderId;
    /**
     * 接收人id
     */
    private Long receiverId;
    /**
     * 内容
     */
    private String content;
    /**
     * 已读标识 1已读 2未读
     */
    private Integer readFlag;
    /**
     * 本条记录是不是我发送的，凭借这个区分左边展示还是右边展示
     */
    private Boolean mine;
    /**
     * 创建时间
     */
    private Date gmtCreate;
}
