package cn.com.duiba.kjy.api.enums.order;

/**
 * 支付来源枚举
 * @author zhanghuifeng
 * date 2019/9/10-5:05 下午
 */
public enum PaySourceEnum {

    OPEN_VIP_MENU(1, "点击菜单中开通会员付费"),
    ARTICLE_MIDDLE_LOCATION(2, "文章中间资源位"),
    WHO_HAS_SEEN_ME(3, "谁看过我转化付费"),
    SITE_SALE_QR(4, "会销码进入直接付费"),
    DISCOUNTS_QR(5, "优惠码推送进入付费"),
    PRIVATE_LETTER(6, "私信资源位"),
    RETURN_INTERCEPT(7, "返回拦截资源位"),
    ARTICLE_BOTTOM_LOCATION(8, "文章底部资源位"),
    ;
    private Integer code;

    private String desc;

    PaySourceEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
