package cn.com.duiba.kjy.api.enums.question;

import java.util.Objects;

/**
 * @author 吴文哲
 * @date 2019-08-26 18:56
 **/
public enum QuestionTypeEnum {

    OPTION_SINGLE((byte)0,"问答题单选"),
    OPTION_MULTI((byte)1,"问答题多选"),
    VOTE_SINGLE((byte)2,"投票单选"),
    VOTE_MULTI((byte)3,"投票多选");

    private Byte type;
    private String desc;

    QuestionTypeEnum(Byte type, String desc){
        this.type = type;
        this.desc = desc;
    }

    public Byte getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean isOption(Byte type){
        QuestionTypeEnum typeEnum = QuestionTypeEnum.getByType(type);
        if(Objects.nonNull(typeEnum) && (typeEnum.equals(QuestionTypeEnum.OPTION_SINGLE) ||
                typeEnum.equals(QuestionTypeEnum.OPTION_MULTI))){
            return true;
        }
        return false;
    }

    public static boolean isVote(Byte type){
        QuestionTypeEnum typeEnum = QuestionTypeEnum.getByType(type);
        if(Objects.nonNull(typeEnum) && (typeEnum.equals(QuestionTypeEnum.VOTE_SINGLE) ||
                typeEnum.equals(QuestionTypeEnum.VOTE_MULTI))){
            return true;
        }
        return false;

    }

    public static QuestionTypeEnum getByType(Byte type){
        for (QuestionTypeEnum enumVal : QuestionTypeEnum.values()) {
            if (enumVal.getType().equals(type)) {
                return enumVal;
            }
        }
        return null;
    }

}
