package cn.com.duiba.kjy.api.enums.sellercard;


import java.util.Objects;

/**
 * Created by dugq on 2019-07-29.
 */
public enum AuthTypeEnum {
    REAL_NAME_AUTH((byte)1,"实名认证"),
    CMF_AUTH((byte)2,"CMF认证"),
    MDRT_AUTH((byte)3,"MDRT认证"),
    MAJOR_AUTH((byte)4,"职业资格认证"),
    ;
    private Byte code;
    private String desc;

    AuthTypeEnum(Byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AuthTypeEnum getByCode(Byte code) {
        for (AuthTypeEnum enumVal : AuthTypeEnum.values()) {
            if (Objects.equals(enumVal.getCode(), code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Byte getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }}
