package cn.com.duiba.kjy.api.remoteservice.interaction;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.interaction.UserBlessingDto;

import java.util.List;

/**
 * @author lizhi
 * @date 2019/9/10 2:23 PM
 */
@AdvancedFeignClient
public interface RemoteUserBlessingService {

    /**
     * 保存用户领祝福信息
     * @param dto 用户领祝福信息
     * @return 主键
     */
    Long save(UserBlessingDto dto);

    /**
     * 根据访问记录表主键集合查询
     * @param visitIds 访问记录表主键集合
     * @return 用户领祝福信息列表
     */
    List<UserBlessingDto> findByVisitIds(List<Long> visitIds);

    /**
     * 根据转载ID和领祝福用户ID查询
     * @param scId 销售员转载内容ID
     * @param userId 领祝福用户ID
     * @return 用户领祝福信息
     */
    UserBlessingDto findByScIdAndUserCache(Long scId, Long userId);
}
