package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.whosawme.SellerCustOriginBo;
import cn.com.duiba.kjy.api.dto.seller.SellerCustomerOriginDto;
import cn.com.duiba.kjy.api.params.seller.SellerCustomerOriginQryParam;
import cn.com.duiba.kjy.api.params.whosawme.CustOriginParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019/7/1 10:07
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerCustomerOriginService {

    /**
     * 根据参数查询列表
     * @param param
     * @return
     */
    List<SellerCustomerOriginDto> listByParams(SellerCustomerOriginQryParam param);

    /**
     * 查询最新一条记录
     * @param param
     * @return
     */
    SellerCustomerOriginDto findOneByParams(SellerCustomerOriginQryParam param);

    /**
     * 保存访问来源记录
     * @param sellerCustomerOriginDto
     * @return
     */
    Integer saveOrigin(SellerCustomerOriginDto sellerCustomerOriginDto);

    /**
     * 获取访客最早的一条来源记录
     * @param param
     * @return
     */
    SellerCustomerOriginDto getFirstVisitRecord(CustOriginParam param);

    /**
     * 获取客户上级来源信息
     * @param param
     * @return
     */
    SellerCustomerOriginDto getOriginVisitRecord(CustOriginParam param);

    /**
     * 获取客户来源
     * @param sellerId
     * @param sellerUserId
     * @return
     */
    SellerCustOriginBo getCustOrigin(Long sellerId, Long sellerUserId);

}
