package cn.com.duiba.kjy.api.remoteservice.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.user.UserForwardDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.user.UserForwardQryParam;

import java.util.List;
import java.util.Map;

/**
 * @author wangbinbin
 * @create 2019/6/29 18:01
 * @descript
 */
@AdvancedFeignClient
public interface RemoteUserForwardService {

    /**
     * 根据代理人id和访客Id查询转发数
     * @param sellerId
     * @param userId
     * @return
     */
    Integer countForwardNumBySellerIdAndUserId(Long sellerId, Long userId);


    /**
     * 查询转发列表
     * @param param
     * @return
     */
    Integer countByParams(UserForwardQryParam param);

    /**
     * 分页查询
     * @param param
     * @return
     */
    Page<UserForwardDto> getForwardPage(UserForwardQryParam param);

    /**
     * 根据条件查询转发记录
     * @param param
     * @return
     */
    List<UserForwardDto> getForwardByCondition(UserForwardQryParam param);
    /**
     * 保存转发记录
     * @param scId
     * @param userId
     * @return
     */
    Boolean saveUserForward(Long scId, Long userId, Long visitId);

    /**
     * 获取转发列表
     * @return
     */
    Map<Long, List<Long>> getForwarMapByScIds(List<Long> scIds);

    /**
     * 初始化历史数据
     */
    void initData();

    List<UserForwardDto> getForwardsByTbVisitId(List<Long> tbVisitIds);


    /**
     * 批量更新为已读
     * @param ids
     * @return
     */
    Integer updateAlreadyReadBatch(List<Long> ids);
}
