/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.question;

import java.util.Objects;

public enum QuestionTypeEnum {
    OPTION_SINGLE((byte)0, "\u95ee\u7b54\u9898\u5355\u9009"),
    OPTION_MULTI((byte)1, "\u95ee\u7b54\u9898\u591a\u9009"),
    VOTE_SINGLE((byte)2, "\u6295\u7968\u5355\u9009"),
    VOTE_MULTI((byte)3, "\u6295\u7968\u591a\u9009");

    private Byte type;
    private String desc;

    private QuestionTypeEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Byte getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static boolean isOption(Byte type) {
        QuestionTypeEnum typeEnum = QuestionTypeEnum.getByType(type);
        return Objects.nonNull((Object)typeEnum) && (typeEnum.equals((Object)OPTION_SINGLE) || typeEnum.equals((Object)OPTION_MULTI));
    }

    public static boolean isVote(Byte type) {
        QuestionTypeEnum typeEnum = QuestionTypeEnum.getByType(type);
        return Objects.nonNull((Object)typeEnum) && (typeEnum.equals((Object)VOTE_SINGLE) || typeEnum.equals((Object)VOTE_MULTI));
    }

    public static QuestionTypeEnum getByType(Byte type) {
        for (QuestionTypeEnum enumVal : QuestionTypeEnum.values()) {
            if (!enumVal.getType().equals(type)) continue;
            return enumVal;
        }
        return null;
    }
}

