/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.question;

import cn.com.duiba.kjy.api.enums.question.QuestionTypeEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public enum SellerCustomerMaterialTypeTempEnum {
    INTERACTION_ANSWER_SINGLE(100, "\u95ee\u7b54\u9898\u5355\u9009"),
    INTERACTION_ANSWER_MULTIPLE(101, "\u95ee\u7b54\u9898\u591a\u9009"),
    INTERACTION_VOTE_SINGLE(102, "\u6295\u7968\u5355\u9009"),
    INTERACTION_VOTE_MULTIPLE(103, "\u6295\u7968\u591a\u9009"),
    INTERACTION_SELLER_ANSWER_SINGLE(104, "\u9500\u552e\u5458\u914d\u7f6e\u7b54\u9898\u5355\u9009"),
    INTERACTION_SELLER_ANSWER_MULTIPLE(105, "\u9500\u552e\u5458\u914d\u7f6e\u7b54\u9898\u591a\u9009"),
    INTERACTION_SELLER_VOTE_SINGLE(106, "\u9500\u552e\u5458\u914d\u7f6e\u6295\u7968\u5355\u9009"),
    INTERACTION_SELLER_VOTE_MULTIPLE(107, "\u9500\u552e\u5458\u914d\u7f6e\u6295\u7968\u591a\u9009"),
    INTERACTION_SELLER_TABLE(108, "\u9500\u552e\u5458\u914d\u7f6e\u8868\u683c");

    private Integer type;
    private String desc;
    private static final Map<Integer, SellerCustomerMaterialTypeTempEnum> ENUM_MAP;

    private SellerCustomerMaterialTypeTempEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isInteraction() {
        return this.getType() < 200;
    }

    public static List<Integer> getAllInteraction() {
        ArrayList<Integer> resultList = new ArrayList<Integer>();
        for (SellerCustomerMaterialTypeTempEnum val : SellerCustomerMaterialTypeTempEnum.values()) {
            if (val.getType() >= 200) continue;
            resultList.add(val.getType());
        }
        return resultList;
    }

    public static List<Integer> getAllOptionInteraction() {
        return Arrays.asList(SellerCustomerMaterialTypeTempEnum.INTERACTION_ANSWER_SINGLE.type, SellerCustomerMaterialTypeTempEnum.INTERACTION_ANSWER_MULTIPLE.type, SellerCustomerMaterialTypeTempEnum.INTERACTION_SELLER_ANSWER_SINGLE.type, SellerCustomerMaterialTypeTempEnum.INTERACTION_SELLER_ANSWER_MULTIPLE.type);
    }

    public static List<Integer> getAllVoteInteraction() {
        return Arrays.asList(SellerCustomerMaterialTypeTempEnum.INTERACTION_VOTE_SINGLE.type, SellerCustomerMaterialTypeTempEnum.INTERACTION_VOTE_MULTIPLE.type, SellerCustomerMaterialTypeTempEnum.INTERACTION_SELLER_VOTE_SINGLE.type, SellerCustomerMaterialTypeTempEnum.INTERACTION_SELLER_VOTE_MULTIPLE.type);
    }

    public static boolean isManagerOption(Integer type) {
        SellerCustomerMaterialTypeTempEnum typeEnum = SellerCustomerMaterialTypeTempEnum.getByType(type);
        return Objects.nonNull((Object)typeEnum) && (typeEnum.equals((Object)INTERACTION_ANSWER_SINGLE) || typeEnum.equals((Object)INTERACTION_ANSWER_MULTIPLE));
    }

    public static boolean isManagerVote(Integer type) {
        SellerCustomerMaterialTypeTempEnum typeEnum = SellerCustomerMaterialTypeTempEnum.getByType(type);
        return Objects.nonNull((Object)typeEnum) && (typeEnum.equals((Object)INTERACTION_VOTE_SINGLE) || typeEnum.equals((Object)INTERACTION_VOTE_MULTIPLE));
    }

    public static SellerCustomerMaterialTypeTempEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static SellerCustomerMaterialTypeTempEnum getByInteractionTypeEnum(QuestionTypeEnum interactionTypeEnum) {
        if (interactionTypeEnum == null) {
            return null;
        }
        Integer type = (int)interactionTypeEnum.getType();
        return SellerCustomerMaterialTypeTempEnum.getByType(type + 100);
    }

    static {
        ENUM_MAP = new HashMap<Integer, SellerCustomerMaterialTypeTempEnum>();
        for (SellerCustomerMaterialTypeTempEnum typeEnum : SellerCustomerMaterialTypeTempEnum.values()) {
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }
}

