package cn.com.duiba.kjy.api.enums.interaction;

import java.util.Objects;

/**
 * @author 吴文哲
 * @date 2019-08-26 18:56
 **/
public enum InteractionTypeEnum {

    OPTION_SINGLE((byte)0,"问答题单选"),
    OPTION_MULTI((byte)1,"问答题多选"),
    VOTE_SINGLE((byte)2,"投票单选"),
    VOTE_MULTI((byte)3,"投票多选");

    private Byte type;
    private String desc;

    InteractionTypeEnum(Byte type, String desc){
        this.type = type;
        this.desc = desc;
    }

    public Byte getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static boolean isOption(Byte type){
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if(Objects.nonNull(typeEnum) && (typeEnum.equals(InteractionTypeEnum.OPTION_SINGLE) ||
                typeEnum.equals(InteractionTypeEnum.OPTION_MULTI))){
            return true;
        }
        return false;
    }

    public static boolean isVote(Byte type){
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if(Objects.nonNull(typeEnum) && (typeEnum.equals(InteractionTypeEnum.VOTE_SINGLE) ||
                typeEnum.equals(InteractionTypeEnum.VOTE_MULTI))){
            return true;
        }
        return false;

    }

    public static InteractionTypeEnum getByType(Byte type){
        for (InteractionTypeEnum enumVal : InteractionTypeEnum.values()) {
            if (enumVal.getType().equals(type)) {
                return enumVal;
            }
        }
        return null;
    }

}
