package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.GrabContentDto;
import cn.com.duiba.kjy.api.params.GrabContentParam;

import java.util.List;

/**
 * Created by dugq on 2019-04-24.
 */
@AdvancedFeignClient
public interface RemoteGrabContentService {
    GrabContentDto selectOne(Long id);

    List<GrabContentDto> selectList(GrabContentParam pojo);

    int update(GrabContentDto record);

    Integer selectCount(GrabContentParam pojo);

    int insert(GrabContentDto pojo);

    Integer delete(Long id);

    /**
     * 把爬虫库的文章移动到文章哭
     * @param id
     * @return
     * @throws KjyCenterException
     */
    Long moving2ArticleList(Long id) throws KjyCenterException;

    /**
     * 旧版本下一篇后期删除
     * @param id
     * @return
     */
    @Deprecated
    GrabContentDto next(Long id);

    /**
     * 下一篇文章
     * @param id
     * @param firstSign
     * @param secondSign
     * @return
     */
    GrabContentDto nextContent(Long id, String firstSign, String secondSign);
}
