package cn.com.duiba.kjy.api.params.classify;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * Created by dugq on 2019-07-08.
 */
@Data
public class ClassifyContentAddParam implements Serializable {
    private static final long serialVersionUID = -466746496759298229L;

    /**
     * 关联表id
     */
    private Long id;
    /**
     * 内容id
     */
    private Long contentId;
    /**
     * 公司id 和 内容的公司ID同步
     */
    private Long companyId;
    /**
     * 分类id
     */
    private Long classifyId;
    /**
     * 排序的位置 null 时不跟新 从1开始
     * 单独跟新时请使用sortClassifyContent 方法，减少额外操作
     */
    private Integer destination;
    /**
     * 定时发布时间
     */
    private Date releaseTimes;
    /**
     * 推荐语。未做强制校验，但只有当内容类型为海报时，首页才会展示
     */
    private String recommendText;
    /**
     * 首页的自定于的标签
     */
    private String recommendTags;
    /**
     * 数据标签
     */
    private String dataTags;

    /**
     * 是否开启  只是标示是否在首页展示，与内容本身的无关
     */
    private Boolean open;

    /**
     * 批量内容id
     */
    private List<Long> batchContentId;

    /**
     * 是否已锁定
     */
    private Boolean isLocked;

    /**
     * 是否开启定时
     */
    private Boolean isOpenTiming;

}
