/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.interaction;

import cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateSourceEnum;
import java.util.HashMap;
import java.util.Map;

public enum InteractionSourceEnum {
    CONTENT_CUSTOM(0, "\u6587\u7ae0\u5185\u914d\u7f6e\u7684\u4e92\u52a8"),
    TEMPLATE(1, "\u4e92\u52a8\u9898\u5e93"),
    SELLER_TEMPLATE(2, "\u9500\u552e\u5458\u6a21\u677f"),
    SELLER_CUSTOM(3, "\u9500\u552e\u5458\u914d\u7f6e");

    private Integer source;
    private String desc;
    private static final Map<Integer, InteractionSourceEnum> ENUM_MAP;

    private InteractionSourceEnum(Integer source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    public Integer getSource() {
        return this.source;
    }

    public String getDesc() {
        return this.desc;
    }

    public static InteractionSourceEnum getBySource(Integer source) {
        if (source == null) {
            return null;
        }
        return ENUM_MAP.get(source);
    }

    public static InteractionSourceEnum getByTemplateSource(Integer templateSource) {
        InteractionTemplateSourceEnum sourceEnum = InteractionTemplateSourceEnum.getBySource(templateSource);
        if (sourceEnum == null) {
            return null;
        }
        if (sourceEnum == InteractionTemplateSourceEnum.TEMPLATE) {
            return TEMPLATE;
        }
        if (sourceEnum == InteractionTemplateSourceEnum.SELLER_TEMPLATE) {
            return SELLER_TEMPLATE;
        }
        return null;
    }

    static {
        ENUM_MAP = new HashMap<Integer, InteractionSourceEnum>();
        for (InteractionSourceEnum sourceEnum : InteractionSourceEnum.values()) {
            ENUM_MAP.put(sourceEnum.getSource(), sourceEnum);
        }
    }
}

