package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * 互动来源
 * @author lizhi
 * @date 2019/9/19 1:48 PM
 */
public enum InteractionSourceEnum {

    CONTENT_CUSTOM(0, "文章内配置的互动"),
    TEMPLATE(1, "互动题库"),
    SELLER_TEMPLATE(2, "销售员模板"),
    SELLER_CUSTOM(3, "销售员配置"),
    GENERAL_TEMPLATE(4, "销售员配置"),
    ;

    private Integer source;

    private String desc;

    InteractionSourceEnum(Integer source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    public Integer getSource() {
        return source;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, InteractionSourceEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionSourceEnum sourceEnum : values()){
            ENUM_MAP.put(sourceEnum.getSource(), sourceEnum);
        }
    }

    public static InteractionSourceEnum getBySource(Integer source) {
        if (source == null) {
            return null;
        }
        return ENUM_MAP.get(source);
    }

    public static InteractionSourceEnum getByTemplateSource(Integer templateSource) {
        InteractionTemplateSourceEnum sourceEnum = InteractionTemplateSourceEnum.getBySource(templateSource);
        if (sourceEnum == null) {
            return null;
        }
        if (sourceEnum == InteractionTemplateSourceEnum.TEMPLATE) {
            return TEMPLATE;
        }
        if (sourceEnum == InteractionTemplateSourceEnum.SELLER_TEMPLATE) {
            return SELLER_TEMPLATE;
        }
        if (sourceEnum == InteractionTemplateSourceEnum.GENERAL_TEMPLATE) {
            return GENERAL_TEMPLATE;
        }
        return null;
    }
}
