package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/9/23 2:00 PM
 */
public enum  InteractionTemplateSourceEnum {

    TEMPLATE(1, "互动题库"),
    SELLER_TEMPLATE(2, "销售员模板"),
    GENERAL_TEMPLATE(3, "销售员配置"),
    ;
    private Integer source;

    private String desc;

    InteractionTemplateSourceEnum(Integer source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    public Integer getSource() {
        return source;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, InteractionTemplateSourceEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionTemplateSourceEnum sourceEnum : values()){
            ENUM_MAP.put(sourceEnum.getSource(), sourceEnum);
        }
    }

    public static InteractionTemplateSourceEnum getBySource(Integer source) {
        if (source == null) {
            return null;
        }
        return ENUM_MAP.get(source);
    }
}
