package cn.com.duiba.kjy.api.enums.privatechat;

import java.util.Objects;

/**
 * @auther: linjianhui
 * @date: 2019-08-22 14:33
 * @description: 触发生成formID的事件
 */
public enum TriggerEventEnum {

    /**
     * 触发事件
     * 1=点击弹层上的关闭按钮、2=点击弹层上的聊天按钮、3=点击头像
     */
    CLOSE_BUTTON(1, "点击弹层上的关闭按钮"),
    CLICK_TO_CHAT(2, "点击弹层上的聊天按钮"),
    CLICK_AVATAR(3, "点击头像"),
    ;

    private Integer code;

    private String desc;

    TriggerEventEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TriggerEventEnum getByCode(Integer code) {
        if (Objects.isNull(code)) {
            return null;
        }
        for (TriggerEventEnum triggerEventEnum : values()) {
            if (Objects.equals(triggerEventEnum.getCode(), code)) {
                return triggerEventEnum;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
