package cn.com.duiba.kjy.api.enums.seller;

/**
 * 销售员来源定义
 * @author zhanghuifeng
 * date 2019-06-25-16:27
 */
public enum SellerFromEnum {

    NORMAL("0", "一般途径途径"),
    POSTER_INVITE("1", "海报邀请(普通邀请)"),
    CARD("2", "内容页换名片邀请（普通邀请）"),
    SITE_SALE_QR("3", "会销扫码（会销邀请）"),
    OUR_INSIDE_RECOMMEND("4", "公司内部销售推荐（只用作绩效记录，不做其它业务用途）"),
    WEEKLY_PUBLICATION("5", "周报中关注客集集"),
    VISITOR_PAYMENT("6", "访客转化为付费用户"),
    NOVICE_TASK("7", "新手任务邀请"),
    NATIONAL_DAY_ACTIVITY("8", "国庆节活动扫码关注客集集"),
    ;
    private String from;
    private String desc;

    SellerFromEnum(String from, String desc) {
        this.from = from;
        this.desc = desc;
    }

    /**
     * x
     * @param from
     * @return
     */
    public static SellerFromEnum getByfrom(String from) {
        for (SellerFromEnum enumVal : SellerFromEnum.values()) {
            if (enumVal.getFrom().equals(from)) {
                return enumVal;
            }
        }
        return null;
    }

    public String getFrom() {
        return from;
    }

    public String getDesc() {
        return desc;
    }
}
