package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.privatechat.SellerContentBaseInfoDto;
import cn.com.duiba.kjy.api.dto.privatechat.SellerContentShareDto;
import cn.com.duiba.kjy.api.dto.seller.SellerShareDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.seller.SellerShareParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019-08-28 15:43
 * @descript
 */
@AdvancedFeignClient
public interface RemoteSellerShareService {

    /**
     * 分页查询分享数据
     * @param param
     * @return
     */
    Page<SellerShareDto> findPageByParam(SellerShareParam param);


    /**
     * 分享列表-代理人分享历史列表
     * @param sellerId
     * @param excludeContentTypes 排除展示的类型
     * @param pageIndex
     * @param pageSize
     * @return
     */
    Page<SellerContentBaseInfoDto> sellerContentHistoryExcludeTypes(Long sellerId,
                                                                    List<String> excludeContentTypes, Integer pageIndex, Integer pageSize);

    /**
     * 获取代理人分享列表
     * @param sellerId
     * @param includeType  分享内容类型
     * @param pageIndex
     * @param pageSize
     * @return
     */
    Page<SellerContentShareDto> sellerContentHistoryIncludeType(Long sellerId, String includeType, Integer pageIndex, Integer pageSize);

}
