package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.DistributionRetunMoneyInfoDto;
import cn.com.duiba.kjy.api.dto.seller.SellerDistributionCountDto;
import cn.com.duiba.kjy.api.dto.seller.SellerDistributionDto;
import cn.com.duiba.kjy.api.enums.seller.DistributionIsLeafEnum;
import cn.com.duiba.kjy.api.params.seller.SellerDistributionPageQryParams;

import java.util.Date;
import java.util.List;

/**
 * 销售员分销绑定关系服务
 * @author zhanghuifeng
 * date 2019-05-22-14:24
 */
@AdvancedFeignClient
public interface RemoteSellerDistributionService {

    /**
     * 根据上级销售员ID集合和绑定的下级销售员返现状态
     * 查询绑定下级销售员数
     * @param superiorIds
     * @param hasPromotion
     * @see cn.com.duiba.kjy.api.enums.seller.PromotionStateEnum
     * @return
     */
    List<SellerDistributionCountDto> findBySuperiorIdsAndStatus(List<Long> superiorIds, Integer hasPromotion);

    /**
     * 获取当前销售员下绑定人数
     * @param superiorId
     * @return
     */
    int findCountBySuperiorId(Long superiorId);

    /**
     * 分页查询销售员下绑定分销人信息(临时绑定关系如果失效了则不显示)
     * @param pageQryParams
     * @return
     */
    List<SellerDistributionDto> find4page(SellerDistributionPageQryParams pageQryParams);

    /**
     * 存在则更新
     * @param dto
     * @return
     */
    Boolean insertExistUpdate(SellerDistributionDto dto);

    /**
     * 新增
     * @param dto
     * @return
     */
    Boolean add(SellerDistributionDto dto);

    /**
     * 根据下级sellerId删除
     * @param sellerId
     * @return
     */
    Boolean delBySellerId(Long sellerId);

    /**
     * 根据销售员ID获取上级绑定关系信息(正式的)
     * @param sellerId
     * @return
     */
    SellerDistributionDto findBySellerId(Long sellerId);

    /**
     * 根据销售员ID获取上级绑定关系信息
     * @param sellerId
     * @return
     */
    List<SellerDistributionDto> listBySellerId(Long sellerId);

    /**
     * 根据下级sellerId删除
     * @param sellerId
     * @param formalState
     * @see cn.com.duiba.kjy.api.enums.seller.DistributionFormalStateEnum
     * @return
     */
    Boolean delBySellerIdAndFormalState(Long sellerId, Integer formalState);

    /**
     * 更新邀请关系保护时间
     * @param sellerId
     * @param formalState
     * @see cn.com.duiba.kjy.api.enums.seller.DistributionFormalStateEnum
     * @param protectExpireDate
     * @return
     */
    Boolean updateProtectExpireDate(Long sellerId, Integer formalState, Date protectExpireDate);

    /**
     * 更新会销特惠有效期
     * @param sellerId
     * @param superiorId
     * @param spValidDate
     * @return
     */
    Boolean updateSpValidDate(Long sellerId, Long superiorId, Date spValidDate);

    DistributionRetunMoneyInfoDto getDistributionReturnMoneyInfo();

    /**
     * 根据上级销售员ID
     * 查询有效列表信息
     * @param superiorId
     * @return
     */
    List<SellerDistributionDto> findBySuperiorId(Long superiorId);

    /**
     * 根据销售员ID获取上级绑定关系数
     * @param sellerId
     * @return
     */
    int countBySellerId(Long sellerId);

    /**
     * 根据主键ID更新叶子节点状态
     * @param id
     * @param leafEnum
     * @return
     */
    Boolean updateIsLeaf(Long id, DistributionIsLeafEnum leafEnum);

    /**
     * 确立当前销售员上级绑定关系(不参与返现)
     * @param sellerId
     * @return
     */
    void establishFinalDis(Long sellerId);
}
