package cn.com.duiba.kjy.api.dto.sellercard;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

import cn.com.duiba.wolf.utils.DateUtils;
import lombok.Data;

/**
 * 销售认证申请记录
 * @author kjj mybatis generator
 * 2019-07-27
 */
@Data
public class SellerAuthRecordDto implements Serializable {
    private static final long serialVersionUID = 15642240642463176L;

    /**
     *
     *主键
     */
    private Long id;

    /**
     *
     *认证类型 1: 实名认证、2职业资格认证、3MDRT认证 、4CMF认证 5.其它认证
     */
    private Integer authType;

    private Long userId;

    private Long sellerId;

    /**
     *
     *认证信息，各种认证多个信息用json
     */
    private String authMessages;

    /**
     *
     *认证照片 单张或者两张 逗号分隔
     */
    private String authImages;

    /**
     *
     *审核状态 1:待审核 2:审核通过 3:审核失败
     */
    private Integer authStatus;

    /**
     *
     *审核人 oss账号
     */
    private String authAdmin;

    /**
     * 审核拒绝理由
     */
    private String refuseReason;

    /**
     *
     *审核时间
     */
    private Date authTime;


    /**
     *
     *创建时间
     */
    private Date gmtCreate;


    /**
     *
     *更新时间
     */
    private Date gmtModified;

}
