package cn.com.duiba.kjy.api.dto.sellercard;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 销售名片
 * @author kjj mybatis generator
 * 2019-07-27
 */
@Data
public class SellerCardDto implements Serializable {
    private static final long serialVersionUID = 15642240642459010L;

    /**
     *
     *主键
     */
    private Long id;

    private Long sellerId;


    /**
     * 销售员昵称
     */
    private String sellerName;

    /**
     * 销售员微信号
     */
    private String wechatNumber;

    /**
     * 销售员手机号
     */
    private String phoneNumber;

    /**
     * 销售员职位
     */
    private String jobPost;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 销售自定头像
     */
    private String avatar;

    /**
     * 英文名
     */
    private String englishName;

    /**
     * 自我介绍
     */
    private String personalIntro;

    /**
     *
     *头像区域风格 1:默认 2:专业大屏照
     */
    private Byte avatarStyle;

    /**
     *
     *背景色 1:默认 2:商务专业
     */
    private Byte backgroundStyle;

    /**
     *
     *专业认证
     */
    private List<AuthenticationDto> authentication;

    /**
     *
     *擅长专业
     */
    private String goodAtMajor;

    /**
     * 荣誉
     */
    private List<HonorDto> honor;

    /**
     * 案例
     */
    private List<CaseDto> cases;

    /**
     * 点滴精彩
     */
    private String splendidImage;

    /**
     *是否编辑过。
     * 名片基本信息存在seller中，名片相关部分存在seller_card中。
     * seller_card表无记录时，hasEdit = false
     */
    private Boolean hasEdit;

    /**
     *
     *创建时间
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     */
    private Date gmtModified;

    /**
     * 微信二维码地址
     */
    private String wechatQrCode;

    /**
     * 小程序二维码
     */
    private String qrCode;

    /**
     * 从业时长
     */
    private Integer exprLength;

    /**
     * 生日
     */
    private String birth;

    /**
     * 省市编码 ,分隔
     */
    private String city;

    /**
     * 城市名称
     */
    private String cityStr;

    /**
     * 省编号
     */
    private String hometown;

    /**
     * 省简称
     */
    private String hometownStr;

    /**
     * 毕业院校
     */
    private String school;

    /**
     * 兴趣爱好 以|分隔
     */
    private String hobby;


    /**
     * 封面图片地址
     */
    private String cover;


}
