package cn.com.duiba.kjy.api.enums.sellercard;

import java.util.Objects;

/**
 * Created by dugq on 2019-07-30.
 *
 * 1:待审核 2:审核通过 3:审核失败
 * 4:拒绝结果已读(针对客户前端展示未提交,针对管理平台 前端展示审核拒绝)
 */
public enum AuthStatusEnum {
    UN_COMMIT(0,"未提交"),
    WAIT(1,"待审核"),
    PASS(2,"审核通过"),
    REFUSE(3,"审核拒绝"),
    REFUSE_READED(4,"拒绝结果已读"),


    ;
    private Integer code;
    private String desc;

    AuthStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public static AuthStatusEnum getByCode(Integer code) {
        for (AuthStatusEnum enumVal : AuthStatusEnum.values()) {
            if (Objects.equals(enumVal.getCode(), code)) {
                return enumVal;
            }
        }
        return null;
    }

}
