package cn.com.duiba.kjy.api.enums.sellercard;


import java.util.Objects;

/**
 * Created by dugq on 2019-07-29.
 */
public enum AuthTypeEnum {
    //名片3.0已废弃
    REAL_NAME_AUTH(1,"实名认证"),
    CMF_AUTH(2,"CMF认证"),
    MDRT_AUTH(3,"MDRT认证"),
    //名片3.0已废弃
    MAJOR_AUTH(4,"职业资格认证"),
    OTHER(5,"其它认证"),
    ;
    private Integer code;
    private String desc;

    AuthTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static AuthTypeEnum getByCode(Integer code) {
        for (AuthTypeEnum enumVal : AuthTypeEnum.values()) {
            if (Objects.equals(enumVal.getCode(), code)) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }}
