package cn.com.duiba.kjy.api.dto.lottery;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2019/10/23 2:53 PM
 */
@Data
public class LotteryDto implements Serializable {

    private static final long serialVersionUID = 4034598027653979226L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 前端页面ID
     */
    private String pageId;

    /**
     * 初始次数
     */
    private Integer initialTimes;

    /**
     * 每次分享增加次数
     */
    private Integer everyShareAddTimes;

    /**
     * 最大次数
     */
    private Integer maxTimes;

    /**
     * 次数类型：0-永久，1-每日
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryTimesTypeEnum
     */
    private Integer timesType;

    /**
     * 出奖规则：0-概率，1-优先级
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryRuleEnum
     */
    private Integer lotteryRule;

    /**
     * 中间页：bit0-指定中奖人，bit1-选券页面
     * @see cn.com.duiba.kjy.api.enums.lottery.MiddlePageSwitchEnum
     */
    private Integer middlePageSwitch;

    /**
     * 排序：降序
     */
    private Long sort;

    /**
     * 状态：0-草稿，1-开启，2-关闭
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryStateEnum
     */
    private Integer state;

    /**
     * 备注
     */
    private String remark;

}

