package cn.com.duiba.kjy.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.activity.ActivityLotteryDto;

import java.util.List;

/**
 * @author lizhi
 * @date 2019/10/24 4:54 PM
 */
@AdvancedFeignClient
public interface RemoteActivityLotteryService {

    /**
     * 新增
     * @param lotteryId 抽奖游戏ID
     * @param activityId 活动ID
     * @return 执行结果
     */
    int save(Long lotteryId, Long activityId);

    /**
     * 根据活动ID删除关联关系
     * @param activityId 活动ID
     * @return 执行结果
     */
    int deleteByActivityId(Long activityId);

    /**
     * 是否可以编辑抽奖游戏
     * @param lotteryId 抽奖游戏ID
     * @return true-可以编辑，false-不可以编辑
     */
    boolean canEditLottery(Long lotteryId);

    /**
     * 根据活动ID集合查询
     * @param activityIds 活动ID
     * @return 活动与抽奖游戏关系列表
     */
    List<ActivityLotteryDto> findByActivityIds(List<Long> activityIds);
}
